<?php
// সম্ভাব্য ত্রুটি প্রদর্শনের জন্য এই কোড যোগ করা হয়েছে
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// ডেটাবেস সংযোগের জন্য db.php ফাইলটি অন্তর্ভুক্ত করুন
include '../includes/db.php';

// فرم সাবমিট হয়েছে কিনা তা পরীক্ষা করুন
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['category_name'])) {
    // ব্যবহারকারীর দেওয়া ইনপুটকে সুরক্ষিত করুন
    $category_name = $conn->real_escape_string($_POST['category_name']);

    // ক্যাটাগরির নাম খালি নয় তা নিশ্চিত করুন
    if (!empty($category_name)) {
        // ডেটাবেসে নতুন ক্যাটাগরি যোগ করার জন্য SQL কোয়েরি
        $sql = "INSERT INTO categories (name) VALUES ('$category_name')";
        
        if ($conn->query($sql) === TRUE) {
            // সফলভাবে যোগ হলে বার্তা দেখান
            $message = "<div class='alert alert-success'>নতুন ক্যাটাগরি সফলভাবে যোগ হয়েছে।</div>";
        } else {
            // কোনো ত্রুটি হলে বার্তা দেখান
            $message = "<div class='alert alert-danger'>ত্রুটি: " . $conn->error . "</div>";
        }
    } else {
        $message = "<div class='alert alert-warning'>ক্যাটাগরির নাম খালি রাখা যাবে না।</div>";
    }
}
?>

<?php include '../includes/header.php'; // হেডার ফাইল অন্তর্ভুক্ত করুন ?>
<?php include '../includes/sidebar.php'; // সাইডবার ফাইল অন্তর্ভুক্ত করুন ?>

<h1 class="mt-4">ক্যাটাগরি ম্যানেজমেন্ট</h1>

<?php
// যদি কোনো বার্তা থাকে, তবে তা এখানে দেখান
if (isset($message)) {
    echo $message;
}
?>

<!-- নতুন ক্যাটাগরি যোগ করার فرم -->
<div class="card my-4">
    <div class="card-header">
        নতুন ক্যাটাগরি যোগ করুন
    </div>
    <div class="card-body">
        <form action="manage_categories.php" method="post">
            <div class="form-group">
                <label for="category_name">ক্যাটাগরির নাম</label>
                <input type="text" name="category_name" id="category_name" class="form-control" placeholder="এখানে ক্যাটাগরির নাম লিখুন" required>
            </div>
            <button type="submit" class="btn btn-primary">যোগ করুন</button>
        </form>
    </div>
</div>

<!-- বিদ্যমান ক্যাটাগরি দেখানোর টেবিল -->
<div class="card">
    <div class="card-header">
        বিদ্যমান ক্যাটাগরিসমূহ
    </div>
    <div class="card-body">
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th style="width: 10%;">আইডি</th>
                    <th>নাম</th>
                    <th style="width: 30%;">তৈরির তারিখ</th>
                </tr>
            </thead>
            <tbody>
                <?php
                // ডেটাবেস থেকে সকল ক্যাটাগরি আনার জন্য SQL কোয়েরি
                $sql_select = "SELECT id, name, created_at FROM categories ORDER BY id DESC";
                $result = $conn->query($sql_select);

                if ($result->num_rows > 0) {
                    // প্রতিটি ক্যাটাগরির জন্য টেবিলের একটি করে রো তৈরি করুন
                    while($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td>" . htmlspecialchars($row["id"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["name"]) . "</td>";
                        echo "<td>" . htmlspecialchars($row["created_at"]) . "</td>";
                        echo "</tr>";
                    }
                } else {
                    // কোনো ক্যাটাগরি না থাকলে বার্তা দেখান
                    echo "<tr><td colspan='3' class='text-center'>এখনো কোনো ক্যাটাগরি যোগ করা হয়নি।</td></tr>";
                }
                ?>
            </tbody>
        </table>
    </div>
</div>

<?php include '../includes/footer.php'; // ফুটার ফাইল অন্তর্ভুক্ত করুন ?>
<?php $conn->close(); // ডেটাবেস সংযোগ বন্ধ করুন ?>